$(document).ready(function () {
    var output = $('#edoutput1B');
    var outf = function (text) {
        output.text(output.text() + text);
    };
    
    var keymap = {
        "Ctrl-Enter" : function (editor1B) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas1B";
            if (editor1B.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas1B').show()
            }
            Sk.pre = "edoutput1B";
            (Sk.TurtleGraphics || (Sk.TurtleGraphics = {})).target = 'mycanvas1B';
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor1B.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        },
        "Shift-Enter": function (editor1B) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas1B";
            Sk.pre = "edoutput1B";
            if (editor1B.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas1B').show()
            }
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor1B.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        }
    }


    var editor1B = CodeMirror.fromTextArea(document.getElementById('code1B'), {
		mode: {name: "python",
               version: 3,
               singleLineStringErrors: false},
        //parserfile: ["parsepython.js"],
        autofocus: true,
        theme: "solarized",
        //path: "static/env/codemirror/js/",
        styleActiveLine: true,
        lineNumbers: true,
        textWrapping: false,
        indentUnit: 4,
        height: "160px",
        fontSize: "9pt",
        autoMatchParens: true,
        extraKeys: keymap,
		autoCloseBrackets: true,
		matchBrackets: true,		
        //parserConfig: {'pythonVersion': 3, 'strictErrors': true}
    });
    editor1B.setSize(600, 160);
    window.code_editor1B = editor1B;
    window.outf = outf;
    window.builtinRead = builtinRead;

    $("#skulpt_run1B").click(function (e) { keymap["Ctrl-Enter"](editor1B)} );

    $('#clearoutput').click(function (e) {
        $('#edoutput1B').text('');
        $('#mycanvas1B').hide();
    });


    function builtinRead(x) {
        if (Sk.builtinFiles === undefined || Sk.builtinFiles["files"][x] === undefined)
            throw "File not found: '" + x + "'";
        return Sk.builtinFiles["files"][x];
    }

});
