$(document).ready(function () {
    var output = $('#edoutput04');
    var outf = function (text) {
        output.text(output.text() + text);
    };
    
    var keymap = {
        "Ctrl-Enter" : function (editor04) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas1";
            if (editor04.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas1').show()
            }
            Sk.pre = "edoutput04";
            (Sk.TurtleGraphics || (Sk.TurtleGraphics = {})).target = 'mycanvas1';
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor04.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        },
        "Shift-Enter": function (editor04) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas1";
            Sk.pre = "edoutput04";
            if (editor04.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas1').show()
            }
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor04.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        }
    }


    var editor04 = CodeMirror.fromTextArea(document.getElementById('code04'), {
		mode: {name: "python",
               version: 3,
               singleLineStringErrors: false},
        //parserfile: ["parsepython.js"],
        autofocus: true,
        theme: "solarized",
        //path: "static/env/codemirror/js/",
        styleActiveLine: true,
        lineNumbers: true,
        textWrapping: false,
        indentUnit: 4,
        height: "160px",
        fontSize: "9pt",
        autoMatchParens: true,
        extraKeys: keymap,
		autoCloseBrackets: true,
		matchBrackets: true,		
        //parserConfig: {'pythonVersion': 3, 'strictErrors': true}
    });
    editor04.setSize(600, 200);
    window.code_editor04 = editor04;
    window.outf = outf;
    window.builtinRead = builtinRead;

    $("#skulpt_run04").click(function (e) { keymap["Ctrl-Enter"](editor04)} );

    $('#clearoutput').click(function (e) {
        $('#edoutput04').text('');
        $('#mycanvas04').hide();
    });


    function builtinRead(x) {
        if (Sk.builtinFiles === undefined || Sk.builtinFiles["files"][x] === undefined)
            throw "File not found: '" + x + "'";
        return Sk.builtinFiles["files"][x];
    }

    editor04.focus();
});
