$(document).ready(function () {
    var output = $('#edoutput2');
    var outf = function (text) {
        output.text(output.text() + text);
    };
    
    var keymap = {
        "Ctrl-Enter" : function (editor2) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas1";
            if (editor2.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas1').show()
            }
            Sk.pre = "edoutput2";
            (Sk.TurtleGraphics || (Sk.TurtleGraphics = {})).target = 'mycanvas1';
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor2.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        },
        "Shift-Enter": function (editor2) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas1";
            Sk.pre = "edoutput2";
            if (editor2.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas1').show()
            }
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor2.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        }
    }


    var editor2 = CodeMirror.fromTextArea(document.getElementById('code2'), {
		mode: {name: "python",
               version: 3,
               singleLineStringErrors: false},
        //parserfile: ["parsepython.js"],
        autofocus: true,
        theme: "solarized",
        //path: "static/env/codemirror/js/",
        styleActiveLine: true,
        lineNumbers: true,
        textWrapping: false,
        indentUnit: 4,
        height: "160px",
        fontSize: "9pt",
        autoMatchParens: true,
        extraKeys: keymap,
		autoCloseBrackets: true,
		matchBrackets: true,		
        //parserConfig: {'pythonVersion': 3, 'strictErrors': true}
    });
    editor2.setSize(600, 195);
    window.code_editor2 = editor2;
    window.outf = outf;
    window.builtinRead = builtinRead;

    $("#skulpt_run2").click(function (e) { keymap["Ctrl-Enter"](editor2)} );

    $('#clearoutput').click(function (e) {
        $('#edoutput2').text('');
        $('#mycanvas2').hide();
    });


    function builtinRead(x) {
        if (Sk.builtinFiles === undefined || Sk.builtinFiles["files"][x] === undefined)
            throw "File not found: '" + x + "'";
        return Sk.builtinFiles["files"][x];
    }

    editor2.focus();
});
