$(document).ready(function () {
    var output = $('#edoutput9');
    var outf = function (text) {
        output.text(output.text() + text);
    };
    
    var keymap = {
        "Ctrl-Enter" : function (editor9) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas9";
            if (editor9.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas9').show()
            }
            Sk.pre = "edoutput9";
            (Sk.TurtleGraphics || (Sk.TurtleGraphics = {})).target = 'mycanvas9';
			Sk.TurtleGraphics.width = '600'; 
            Sk.TurtleGraphics.height = '230';
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor9.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        },
        "Shift-Enter": function (editor9) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas9";
            Sk.pre = "edoutput9";
            if (editor9.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas9').show()
            }
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor9.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        }
    }


    var editor9 = CodeMirror.fromTextArea(document.getElementById('code9'), {
		mode: {name: "python",
               version: 3,
               singleLineStringErrors: false},
        //parserfile: ["parsepython.js"],
        autofocus: true,
        theme: "solarized",
        //path: "static/env/codemirror/js/",
        styleActiveLine: true,
        lineNumbers: true,
        textWrapping: false,
        indentUnit: 4,
        height: "160px",
        fontSize: "9pt",
        autoMatchParens: true,
        extraKeys: keymap,
		autoCloseBrackets: true,
		matchBrackets: true,		
        //parserConfig: {'pythonVersion': 3, 'strictErrors': true}
    });
    editor9.setSize(600, 125);
    window.code_editor9 = editor9;
    window.outf = outf;
    window.builtinRead = builtinRead;

    $("#skulpt_run9").click(function (e) { keymap["Ctrl-Enter"](editor9)} );

    $('#clearoutput').click(function (e) {
        $('#edoutput9').text('');
        $('#mycanvas9').hide();
    });


    function builtinRead(x) {
        if (Sk.builtinFiles === undefined || Sk.builtinFiles["files"][x] === undefined)
            throw "File not found: '" + x + "'";
        return Sk.builtinFiles["files"][x];
    }

});
