$(document).ready(function () {
    var output = $('#edoutput6');
    var outf = function (text) {
        output.text(output.text() + text);
    };
    
    var keymap = {
        "Ctrl-Enter" : function (editor6) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas6";
            if (editor6.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas6').show()
            }
            Sk.pre = "edoutput6";
            (Sk.TurtleGraphics || (Sk.TurtleGraphics = {})).target = 'mycanvas6';
			Sk.TurtleGraphics.width = '600'; 
            Sk.TurtleGraphics.height = '230';
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor6.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        },
        "Shift-Enter": function (editor6) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas6";
            Sk.pre = "edoutput6";
            if (editor6.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas6').show()
            }
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor6.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        }
    }


    var editor6 = CodeMirror.fromTextArea(document.getElementById('code6'), {
		mode: {name: "python",
               version: 3,
               singleLineStringErrors: false},
        //parserfile: ["parsepython.js"],
        autofocus: true,
        theme: "solarized",
        //path: "static/env/codemirror/js/",
        styleActiveLine: true,
        lineNumbers: true,
        textWrapping: false,
        indentUnit: 4,
        height: "160px",
        fontSize: "9pt",
        autoMatchParens: true,
        extraKeys: keymap,
		autoCloseBrackets: true,
		matchBrackets: true,		
        //parserConfig: {'pythonVersion': 3, 'strictErrors': true}
    });
    editor6.setSize(600, 270);
    window.code_editor6 = editor6;
    window.outf = outf;
    window.builtinRead = builtinRead;

    $("#skulpt_run6").click(function (e) { keymap["Ctrl-Enter"](editor6)} );

    $('#clearoutput').click(function (e) {
        $('#edoutput6').text('');
        $('#mycanvas6').hide();
    });


    function builtinRead(x) {
        if (Sk.builtinFiles === undefined || Sk.builtinFiles["files"][x] === undefined)
            throw "File not found: '" + x + "'";
        return Sk.builtinFiles["files"][x];
    }

});
