$(document).ready(function () {
    var output = $('#edoutput5');
    var outf = function (text) {
        output.text(output.text() + text);
    };
    
    var keymap = {
        "Ctrl-Enter" : function (editor5) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas5";
            if (editor5.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas5').show()
            }
            Sk.pre = "edoutput5";
            (Sk.TurtleGraphics || (Sk.TurtleGraphics = {})).target = 'mycanvas5';
			Sk.TurtleGraphics.width = '600'; 
            Sk.TurtleGraphics.height = '230';
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor5.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        },
        "Shift-Enter": function (editor5) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas5";
            Sk.pre = "edoutput5";
            if (editor5.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas5').show()
            }
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor5.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        }
    }


    var editor5 = CodeMirror.fromTextArea(document.getElementById('code5'), {
		mode: {name: "python",
               version: 3,
               singleLineStringErrors: false},
        //parserfile: ["parsepython.js"],
        autofocus: true,
        theme: "solarized",
        //path: "static/env/codemirror/js/",
        styleActiveLine: true,
        lineNumbers: true,
        textWrapping: false,
        indentUnit: 4,
        height: "160px",
        fontSize: "9pt",
        autoMatchParens: true,
        extraKeys: keymap,
		autoCloseBrackets: true,
		matchBrackets: true,		
        //parserConfig: {'pythonVersion': 3, 'strictErrors': true}
    });
    editor5.setSize(600, 170);
    window.code_editor5 = editor5;
    window.outf = outf;
    window.builtinRead = builtinRead;

    $("#skulpt_run5").click(function (e) { keymap["Ctrl-Enter"](editor5)} );

    $('#clearoutput').click(function (e) {
        $('#edoutput5').text('');
        $('#mycanvas5').hide();
    });


    function builtinRead(x) {
        if (Sk.builtinFiles === undefined || Sk.builtinFiles["files"][x] === undefined)
            throw "File not found: '" + x + "'";
        return Sk.builtinFiles["files"][x];
    }

    editor5.focus();
});
