$(document).ready(function () {
    var output = $('#edoutput3');
    var outf = function (text) {
        output.text(output.text() + text);
    };
    
    var keymap = {
        "Ctrl-Enter" : function (editor3) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas3";
            if (editor3.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas3').show()
            }
            Sk.pre = "edoutput3";
            (Sk.TurtleGraphics || (Sk.TurtleGraphics = {})).target = 'mycanvas3';
			Sk.TurtleGraphics.width = '600'; 
            Sk.TurtleGraphics.height = '240';
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor3.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        },
        "Shift-Enter": function (editor3) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas3";
            Sk.pre = "edoutput3";
            if (editor3.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas3').show()
            }
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor3.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        }
    }


    var editor3 = CodeMirror.fromTextArea(document.getElementById('code3'), {
		mode: {name: "python",
               version: 3,
               singleLineStringErrors: false},
        //parserfile: ["parsepython.js"],
        autofocus: true,
        theme: "solarized",
        //path: "static/env/codemirror/js/",
        styleActiveLine: true,
        lineNumbers: true,
        textWrapping: false,
        indentUnit: 4,
        height: "160px",
        fontSize: "9pt",
        autoMatchParens: true,
        extraKeys: keymap,
		autoCloseBrackets: true,
		matchBrackets: true,		
        //parserConfig: {'pythonVersion': 3, 'strictErrors': true}
    });
    editor3.setSize(600, 130);
    window.code_editor3 = editor3;
    window.outf = outf;
    window.builtinRead = builtinRead;

    $("#skulpt_run3").click(function (e) { keymap["Ctrl-Enter"](editor3)} );

    $('#clearoutput').click(function (e) {
        $('#edoutput3').text('');
        $('#mycanvas3').hide();
    });


    function builtinRead(x) {
        if (Sk.builtinFiles === undefined || Sk.builtinFiles["files"][x] === undefined)
            throw "File not found: '" + x + "'";
        return Sk.builtinFiles["files"][x];
    }

});
