$(document).ready(function () {
    var output = $('#edoutput10');
    var outf = function (text) {
        output.text(output.text() + text);
    };
    
    var keymap = {
        "Ctrl-Enter" : function (editor10) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas10";
            if (editor10.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas10').show()
            }
            Sk.pre = "edoutput10";
            (Sk.TurtleGraphics || (Sk.TurtleGraphics = {})).target = 'mycanvas10';
			Sk.TurtleGraphics.width = '600'; 
            Sk.TurtleGraphics.height = '230';
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor10.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        },
        "Shift-Enter": function (editor10) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas10";
            Sk.pre = "edoutput10";
            if (editor10.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas10').show()
            }
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor10.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        }
    }


    var editor10 = CodeMirror.fromTextArea(document.getElementById('code10'), {
		mode: {name: "python",
               version: 3,
               singleLineStringErrors: false},
        //parserfile: ["parsepython.js"],
        autofocus: true,
        theme: "solarized",
        //path: "static/env/codemirror/js/",
        styleActiveLine: true,
        lineNumbers: true,
        textWrapping: false,
        indentUnit: 4,
        height: "160px",
        fontSize: "9pt",
        autoMatchParens: true,
        extraKeys: keymap,
		autoCloseBrackets: true,
		matchBrackets: true,		
        //parserConfig: {'pythonVersion': 3, 'strictErrors': true}
    });
    editor10.setSize(600, 180);
    window.code_editor10 = editor10;
    window.outf = outf;
    window.builtinRead = builtinRead;

    $("#skulpt_run10").click(function (e) { keymap["Ctrl-Enter"](editor10)} );

    $('#clearoutput').click(function (e) {
        $('#edoutput10').text('');
        $('#mycanvas10').hide();
    });


    function builtinRead(x) {
        if (Sk.builtinFiles === undefined || Sk.builtinFiles["files"][x] === undefined)
            throw "File not found: '" + x + "'";
        return Sk.builtinFiles["files"][x];
    }

});
