$(document).ready(function () {
    var output = $('#edoutput8');
    var outf = function (text) {
        output.text(output.text() + text);
    };
    
    var keymap = {
        "Ctrl-Enter" : function (editor8) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas8";
            if (editor8.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas8').show()
            }
            Sk.pre = "edoutput8";
            (Sk.TurtleGraphics || (Sk.TurtleGraphics = {})).target = 'mycanvas8';
			Sk.TurtleGraphics.width = '600'; 
            Sk.TurtleGraphics.height = '230';
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor8.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        },
        "Shift-Enter": function (editor8) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas8";
            Sk.pre = "edoutput8";
            if (editor8.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas8').show()
            }
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor8.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        }
    }


    var editor8 = CodeMirror.fromTextArea(document.getElementById('code8'), {
		mode: {name: "python",
               version: 3,
               singleLineStringErrors: false},
        //parserfile: ["parsepython.js"],
        autofocus: true,
        theme: "solarized",
        //path: "static/env/codemirror/js/",
        styleActiveLine: true,
        lineNumbers: true,
        textWrapping: false,
        indentUnit: 4,
        height: "160px",
        fontSize: "9pt",
        autoMatchParens: true,
        extraKeys: keymap,
		autoCloseBrackets: true,
		matchBrackets: true,		
        //parserConfig: {'pythonVersion': 3, 'strictErrors': true}
    });
    editor8.setSize(600, 125);
    window.code_editor8 = editor8;
    window.outf = outf;
    window.builtinRead = builtinRead;

    $("#skulpt_run8").click(function (e) { keymap["Ctrl-Enter"](editor8)} );

    $('#clearoutput').click(function (e) {
        $('#edoutput8').text('');
        $('#mycanvas8').hide();
    });


    function builtinRead(x) {
        if (Sk.builtinFiles === undefined || Sk.builtinFiles["files"][x] === undefined)
            throw "File not found: '" + x + "'";
        return Sk.builtinFiles["files"][x];
    }

});
