$(document).ready(function () {
    var output = $('#edoutput7');
    var outf = function (text) {
        output.text(output.text() + text);
    };
    
    var keymap = {
        "Ctrl-Enter" : function (editor7) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas7";
            if (editor7.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas7').show()
            }
            Sk.pre = "edoutput7";
            (Sk.TurtleGraphics || (Sk.TurtleGraphics = {})).target = 'mycanvas7';
			Sk.TurtleGraphics.width = '600'; 
            Sk.TurtleGraphics.height = '230';
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor7.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        },
        "Shift-Enter": function (editor7) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas7";
            Sk.pre = "edoutput7";
            if (editor7.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas7').show()
            }
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor7.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        }
    }


    var editor7 = CodeMirror.fromTextArea(document.getElementById('code7'), {
		mode: {name: "python",
               version: 3,
               singleLineStringErrors: false},
        //parserfile: ["parsepython.js"],
        autofocus: true,
        theme: "solarized",
        //path: "static/env/codemirror/js/",
        styleActiveLine: true,
        lineNumbers: true,
        textWrapping: false,
        indentUnit: 4,
        height: "160px",
        fontSize: "9pt",
        autoMatchParens: true,
        extraKeys: keymap,
		autoCloseBrackets: true,
		matchBrackets: true,		
        //parserConfig: {'pythonVersion': 3, 'strictErrors': true}
    });
    editor7.setSize(600, 140);
    window.code_editor7 = editor7;
    window.outf = outf;
    window.builtinRead = builtinRead;

    $("#skulpt_run7").click(function (e) { keymap["Ctrl-Enter"](editor7)} );

    $('#clearoutput').click(function (e) {
        $('#edoutput7').text('');
        $('#mycanvas7').hide();
    });


    function builtinRead(x) {
        if (Sk.builtinFiles === undefined || Sk.builtinFiles["files"][x] === undefined)
            throw "File not found: '" + x + "'";
        return Sk.builtinFiles["files"][x];
    }

});
