$(document).ready(function () {
    var output = $('#edoutput0');
    var outf = function (text) {
        output.text(output.text() + text);
    };
    
    var keymap = {
        "Ctrl-Enter" : function (editor0) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas1";
            if (editor0.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas1').show()
            }
            Sk.pre = "edoutput0";
            (Sk.TurtleGraphics || (Sk.TurtleGraphics = {})).target = 'mycanvas1';
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor0.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        },
        "Shift-Enter": function (editor0) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas1";
            Sk.pre = "edoutput0";
            if (editor0.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas1').show()
            }
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor0.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        }
    }


    var editor0 = CodeMirror.fromTextArea(document.getElementById('code0'), {
		mode: {name: "python",
               version: 3,
               singleLineStringErrors: false},
        //parserfile: ["parsepython.js"],
        autofocus: true,
        theme: "solarized",
        //path: "static/env/codemirror/js/",
        styleActiveLine: true,
        lineNumbers: true,
        textWrapping: false,
        indentUnit: 4,
        height: "160px",
        fontSize: "9pt",
        autoMatchParens: true,
        extraKeys: keymap,
		autoCloseBrackets: true,
		matchBrackets: true,		
        //parserConfig: {'pythonVersion': 3, 'strictErrors': true}
    });
    editor0.setSize(600, 125);
    window.code_editor0 = editor0;
    window.outf = outf;
    window.builtinRead = builtinRead;

    $("#skulpt_run0").click(function (e) { keymap["Ctrl-Enter"](editor0)} );

    $('#clearoutput').click(function (e) {
        $('#edoutput0').text('');
        $('#mycanvas0').hide();
    });


    function builtinRead(x) {
        if (Sk.builtinFiles === undefined || Sk.builtinFiles["files"][x] === undefined)
            throw "File not found: '" + x + "'";
        return Sk.builtinFiles["files"][x];
    }

    editor0.focus();
});
