$(document).ready(function () {
    var output = $('#edoutput1');
    var outf = function (text) {
        output.text(output.text() + text);
    };
    
    var keymap = {
        "Ctrl-Enter" : function (editor1) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas1";
            if (editor1.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas1').show()
            }
            Sk.pre = "edoutput1";
            (Sk.TurtleGraphics || (Sk.TurtleGraphics = {})).target = 'mycanvas1';
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor1.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        },
        "Shift-Enter": function (editor1) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas1";
            Sk.pre = "edoutput1";
            if (editor1.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas1').show()
            }
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor1.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        }
    }


    var editor1 = CodeMirror.fromTextArea(document.getElementById('code1'), {
		mode: {name: "python",
               version: 3,
               singleLineStringErrors: false},
        //parserfile: ["parsepython.js"],
        autofocus: true,
        theme: "solarized",
        //path: "static/env/codemirror/js/",
        styleActiveLine: true,
        lineNumbers: true,
        textWrapping: false,
        indentUnit: 4,
        height: "160px",
        fontSize: "9pt",
        autoMatchParens: true,
        extraKeys: keymap,
		autoCloseBrackets: true,
		matchBrackets: true,		
        //parserConfig: {'pythonVersion': 3, 'strictErrors': true}
    });
    editor1.setSize(600, 125);
    window.code_editor1 = editor1;
    window.outf = outf;
    window.builtinRead = builtinRead;

    $("#skulpt_run1").click(function (e) { keymap["Ctrl-Enter"](editor1)} );

    $('#clearoutput').click(function (e) {
        $('#edoutput1').text('');
        $('#mycanvas1').hide();
    });


    function builtinRead(x) {
        if (Sk.builtinFiles === undefined || Sk.builtinFiles["files"][x] === undefined)
            throw "File not found: '" + x + "'";
        return Sk.builtinFiles["files"][x];
    }

    editor1.focus();
});
