$(document).ready(function () {
    var output = $('#edoutput4');
    var outf = function (text) {
        output.text(output.text() + text);
    };
    
    var keymap = {
        "Ctrl-Enter" : function (editor4) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas1";
            if (editor4.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas1').show()
            }
            Sk.pre = "edoutput4";
            (Sk.TurtleGraphics || (Sk.TurtleGraphics = {})).target = 'mycanvas1';
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor4.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        },
        "Shift-Enter": function (editor4) {
            Sk.configure({output: outf, read: builtinRead});
            Sk.canvas = "mycanvas1";
            Sk.pre = "edoutput4";
            if (editor4.getValue().indexOf('turtle') > -1 ) {
                $('#mycanvas1').show()
            }
            try {
                Sk.misceval.asyncToPromise(function() {
                    return Sk.importMainWithBody("<stdin>",false,editor4.getValue(),true);
                });
            } catch(e) {
                outf(e.toString() + "\n")
            }
        }
    }


    var editor4 = CodeMirror.fromTextArea(document.getElementById('code4'), {
		mode: {name: "python",
               version: 3,
               singleLineStringErrors: false},
        //parserfile: ["parsepython.js"],
        autofocus: true,
        theme: "solarized",
        //path: "static/env/codemirror/js/",
        styleActiveLine: true,
        lineNumbers: true,
        textWrapping: false,
        indentUnit: 4,
        height: "160px",
        fontSize: "9pt",
        autoMatchParens: true,
        extraKeys: keymap,
		autoCloseBrackets: true,
		matchBrackets: true,		
        //parserConfig: {'pythonVersion': 3, 'strictErrors': true}
    });
    editor4.setSize(500, 105);
    window.code_editor4 = editor4;
    window.outf = outf;
    window.builtinRead = builtinRead;

    $("#skulpt_run4").click(function (e) { keymap["Ctrl-Enter"](editor4)} );

    $('#clearoutput').click(function (e) {
        $('#edoutput4').text('');
        $('#mycanvas4').hide();
    });


    function builtinRead(x) {
        if (Sk.builtinFiles === undefined || Sk.builtinFiles["files"][x] === undefined)
            throw "File not found: '" + x + "'";
        return Sk.builtinFiles["files"][x];
    }

    editor4.focus();
});
