
# Laser contre Astéroides et loi de réflexion

# VERSION FINALE


import pygame,time,math #Importation des bibliothèques

from random import randint,shuffle,randrange

import os # pour pouvoir faire une pause


pygame.init()

        
# MISE EN PLACE DES ELEMENTS GRAPHIQUES
 
# Dimensions de l'écran

noir = 0, 0, 0
ecran = pygame.display.set_mode((800, 600 )) # Affichage en 800X600
# nb pas de sons sans affichage préalable !

# Introduction (Hommage à Alien, le 8ème passager ; )
son_teletype=pygame.mixer.Sound("Data/Sons/TELETYPE.wav")
myfont = pygame.font.SysFont("lucida console", 40)
intro_jeu=["contact radar vecteur 180 180 0","signature inconnue ","activation système armement", "activation bouclier"]

global i
for i in intro_jeu :# i prend successivement les valeurs de intro_jeu
        son_teletype.play(0)
        ecran.blit(myfont.render(i,1,(24,157,46)),(20,270))
        time.sleep(2)
        pygame.display.flip()
        ecran.fill(noir)
        time.sleep(1)
        pygame.display.flip()

#PREPARATION DES SONS

#Chargement des sons
son_intro=pygame.mixer.Sound("Data/Sons/cosmonaute2.wav")
son_laser=pygame.mixer.Sound("Data/Sons/tir_laser.wav")
son_explosion=pygame.mixer.Sound("Data/Sons/impact2.wav")
pygame.mixer.music.load("Data/Sons/salle_des_machines4.wav")

# Intro sonore
son_intro.play(0)
time.sleep(6) 
pygame.mixer.music.play(-1) # son ambiance salle des machines en boucle


# Chargement de l'image de l'astéroide et positionnement au point de coordonnées (750;200)

asteroide = pygame.image.load("Data/Images/asteroide.gif")
aster_masque = pygame.image.load("Data/Images/aster_masque.gif")
    	 
# Chargement de l'image du vaisseau et positionnement au point de coordonnées (25;495)

souscoupe = pygame.image.load("Data/Images/souscoupe.gif")
ecran.blit(souscoupe,(0,550)) 
aster_noir = pygame.image.load("Data/Images/asteroide_noir.jpg")

# Chargement et positionnement de l'image du nuage de poussière

nuage = pygame.image.load("Data/Images/nuage.gif")
ecran.blit(nuage,(0,300)) 

pygame.display.flip()

# Tracé du réflecteur de rayons
pygame.draw.line(ecran, 0xFFFFFF, (0,150), (800, 150))

# Chargement de l'image de l'explosion

boum = pygame.image.load("Data/Images/explosion.gif")
pygame.display.flip()


# INITIALISATION DES VARIABLES 

h=0  # l'incrémentation de h permet d'assurer le défilement horizontale de l'astéroïde

continuer=1 # la variable continuer controle la sortie de la boucle while

coef_vitesse=[5,7.5,10,15]

alt1=randrange(160,200,10) # génération d'altitudes aléatoires des astéroides
alt2=randrange(200,250,10)
alt3=randrange(380,450,10)
alt4=randrange(450,500,10)

altitudes_asteroides=[alt1,alt2,alt3,alt4]

decalages=[0,50,100,150] # Pour éviter l'alignement initial 
num_aster=[0,1,2,3] # permet de gérer grace à la commande liste.remove(), la destruction des astéroides
abscisses=[0,0,0,0] 
ordonnees=[0,0,0,0]

score = 0 # la variable du score : nb d'astéroïdes touchés



event = pygame.event.poll() 



# DEFINITION DES FONCTIONS:

# Génération d'un astéroïde

def nouvel_aster(h):
        global k
        for k in num_aster:
                
                x_asteroide=750-coef_vitesse[k]*h-decalages[k]
                y_asteroide=altitudes_asteroides[k]

                abscisses[k]=x_asteroide
                ordonnees[k]=y_asteroide
                
                ecran.blit(asteroide,(x_asteroide,y_asteroide))  # Astéroide animé d'un mouvement rectiligne uniforme 
                ecran.blit(aster_masque,(x_asteroide+10,y_asteroide)) # Masquer la "trace" de l'astéroide
                       
        pygame.display.flip() # Actualisation de l'affichage écran
      
       

# On définit notre fonction laser

def laser(event):

# On vise à l'aide du pointeur, on commence donc par récupérer la position du pointeur
    
        posSouris = pygame.mouse.get_pos()  # Récupérer la position du pointeur
        
# Tracé du premier segment du rayon laser ( le segment est porté par la droite d'équation y=ax+b)

        a=(555-posSouris[1])/(25-posSouris[0]) # On calcule le coefficient directeur du rayon laser
        b=555-25*a                             # On calcule l'ordonnée à l'origine du rayon laser
        b1=b+a*((300-b)/a-((350-b)/a+50/(2*math.sqrt(a*a+0.75))))#calcul de l'ordonnée à l'origine du rayon émergent du nuage 
        pygame.draw.line(ecran, 0x00FF00, (25,555), ((350-b)/a, 350))#premier segment
        son_laser.play(0)
        
 #Tracé du rayon réfracté dans le nuage d'indice 2    
        pygame.draw.line(ecran, 0x00FF00, ((350-b)/a,350),((350-b)/a+50/(2*math.sqrt(a*a+0.75)),300))
        
 # tracé du rayon émergent du nuage

        pygame.draw.line(ecran, 0x00FF00, ((350-b)/a+50/(2*math.sqrt(a*a+0.75)),300),((150-b1)/a,150))
     
# Tracé du rayon réfléchi par la paroi supérieure
        pygame.draw.line(ecran, 0x00FF00, ((150-b1)/a, 150), ((-b1)/a, 300) )
        pygame.display.flip()
        
# rayon réfléchi sous le nuage
        pygame.draw.line(ecran, 0x00FF00, ((350-b)/a, 350), ((-b)/a, 600) )
        pygame.display.flip()
                         
        test_tir(posSouris, h)
        time.sleep(0.1) # Une pause pour avoir le temps de voir quelque chose
        ecran.fill(noir) # On efface tout et on réinstalle le décor
        pygame.draw.line(ecran, 0xFFFFFF, (0,150), (800, 150))
        ecran.blit(souscoupe,(0,550))
        ecran.blit(nuage,(0,300))
        pygame.display.flip()

       

        
# La fonction test_tir() permet de déterminer si la cible est atteinte

def test_tir(posSouris, h):
        
                # droite portant le rayon réfracté : y=ax+b1 / rayon incident : y=ax+b
                a=(555-posSouris[1])/(25-posSouris[0]) 
                b=555-25*a
                b1=b+a*((300-b)/a-((350-b)/a+50/(2*math.sqrt(a*a+0.75))))
                
                # Equation de la droite portant le rayon réfléchi sous la forme y=a_rx+b_r avec:
                
                a_r= -(555-posSouris[1])/(25-posSouris[0]) # Coefficient directeur
                b_r= -200-25*a_r # Ordonnée à l'origine

                # Calcul de la distance entre le centre de l'astéroide et le rayon laser:
                rac_i=math.sqrt(1+a*a)
                rac_r=math.sqrt(1+a_r*a_r)
                
                for k in range(0,4,1): # on teste pour chaque série de 4 astéroides
                        dr=abs(a_r*(abscisses[k])-ordonnees[k]+b_r)/rac_r # distance rayon réfléchi - astéroïde
                        dinc=abs(a*(abscisses[k])-ordonnees[k]+b)/rac_i # distance rayon incident - astéroïde
                        di=abs(a*(abscisses[k])-ordonnees[k]+b1)/rac_i # distance rayon réfracté - astéroïde
                        if (di<20 or dr<20 or dinc<20) and k in num_aster:  # "and k in num_aster" évite les doubles explosions en cas de tirs rapprochés
                                
                                explosion(k) # Explosion si le laser est assez proche de l'astéroide, on passe "k" en paramètre
                                
                            
                                       
#Fonction explosion si on touche la cible		  	
def explosion(k):

    global continuer# la variable continuer permet de controler la boucle "while" on lui donne une portée globale

    continuer=0# On quite la boucle "infinie"


    # Gestion du score
    global score
                                
    if (coef_vitesse[k]==5): # Incrémentation du score en fonction de la vitesse de la cible
        score +=1
    elif (coef_vitesse[k]==7.5):
        score +=5
    elif (coef_vitesse[k]==10):
        score +=10
    elif (coef_vitesse[k]==15):
        score +=20
    
    
    ecran.fill(noir)# Fond noir
    ecran.blit(boum,(abscisses[k],ordonnees[k]))
    num_aster.remove(k)
    time.sleep(0.05)# Une petite pause pour voir quelque chose
    pygame.draw.line(ecran, 0xFFFFFF, (0,150), (800, 150))# On réinstalle le décor
    ecran.blit(souscoupe,(0,550))# On réinstalle le décor
    ecran.blit(nuage,(0,300))# On réinstalle le décor
    pygame.display.flip()
    continuer=1 # Reprise de la boucle
    son_explosion.play(0)#On joue le son de l'explosion
    

# BOUCLE ASSURANT LE DEROULEMENT DU JEU


while continuer:

# Affichage et mise à jour du score
        myfont = pygame.font.SysFont("arial", 16)
        affichage_score = myfont.render(str(score),1,(255,255,255))
        compteur_score=myfont.render("SCORE",1,(255,255,255))
        presentation1=myfont.render("DEFENDEZ LA BASE",1,(255,255,255))
        presentation2=myfont.render("DETRUISEZ LES ASTEROIDES",1,(255,255,255))
        ecran.blit(compteur_score,(90,70))
        ecran.blit(affichage_score,(100,100))
        ecran.blit(presentation1,(400,50))
        ecran.blit(presentation2,(400,100))
        pygame.display.flip()

        
        ev = pygame.event.poll() 

    # Déclenchement du tir (fonction laser) grace clic-gauche de la souris

        if ev.type == pygame.MOUSEBUTTONDOWN:
                laser(ev) # Déclenchement du tir à la souris
                

        nouvel_aster(h%180)
        h+=0.25 # Vitesse de défilement de l'astéroide
        
        
        if (h%180==0):                 # au bout d'un tour...
                num_aster=[0,1,2,3]    # On relance une série complète de 4
                shuffle(coef_vitesse)  # Pour briser la monotonie, on brasse la liste des vitesses
                shuffle(decalages)     # de meme pour la liste des décalages
                
    
    
        pygame.display.update()#Mise à jour de l'affichage
   
        pygame.display.flip()
         


   
      
       




   
    
    
   
  
   

         


   
      
       




   
    
    
   
  
   
